<?php include('../config/db.php'); ?>
<!DOCTYPE html>
<html lang="th">
<head>
<meta charset="UTF-8">
<title>จองพระวัดสันติสุข</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="../assets/css/style.css" rel="stylesheet">
<style>
.dual-img{display:flex;justify-content:center;gap:10px;flex-wrap:wrap}
.img-block{text-align:center}
.img-block img{width:80px;height:80px;object-fit:cover;border-radius:5px;border:1px solid #ccc}
.img-label{font-size:0.8rem;color:#555;display:block}
.step-box{display:none}
.step-box.active{display:block}
</style>
</head>
<body class="bg-light">
<div class="container py-5">
  <h2 class="text-center mb-4">ระบบจองพระวัดสันติสุข</h2>
  <form id="bookingForm" action="checkout.php" method="post">
    <div id="step1" class="step-box active">
      <h5>1️⃣ เลือกรายการพระ</h5>
      <table class="table table-bordered bg-white">
        <thead class="table-secondary text-center">
          <tr><th>เลือก</th><th>รูปภาพ</th><th>ชื่อพระ</th><th>ราคา</th><th>คงเหลือ</th><th>จำนวน</th></tr>
        </thead>
        <tbody>
        <?php
        $res = $conn->query("SELECT * FROM products");
        while($r=$res->fetch_assoc()):
          $img1 = !empty($r['img1'])?"../uploads/products/{$r['img1']}":"";
          $img2 = !empty($r['img2'])?"../uploads/products/{$r['img2']}":"";
        ?>
        <tr>
          <td class="text-center"><input type="checkbox" name="product_id[]" value="<?=$r['id']?>"></td>
          <td class="text-center">
            <?php if($img1||$img2): ?>
              <div class="dual-img">
                <?php if($img1): ?><div class="img-block"><img src="<?=$img1?>"><span class="img-label">ด้านหน้า</span></div><?php endif; ?>
                <?php if($img2): ?><div class="img-block"><img src="<?=$img2?>"><span class="img-label">ด้านหลัง</span></div><?php endif; ?>
              </div>
            <?php endif; ?>
          </td>
          <td><?=$r['name']?></td>
          <td><?=number_format($r['price'],2)?></td>
          <td><?=$r['stock']>0?$r['stock']:"<span class='text-danger'>หมด (Free Order)</span>"?></td>
          <td><input type="number" name="qty[<?=$r['id']?>]" value="1" min="1" class="form-control form-control-sm" style="width:90px;"></td>
        </tr>
        <?php endwhile; ?>
        </tbody>
      </table>
      <div class="text-end"><button type="button" id="nextStep" class="btn btn-primary">ถัดไป ➜</button></div>
    </div>

    <div id="step2" class="step-box">
      <h5>2️⃣ เลือกวิธีรับสินค้า</h5>
      <div class="mb-3">
        <select name="receive_method" id="receiveMethod" class="form-control" required>
          <option value="">-- เลือกวิธีรับสินค้า --</option>
          <option value="รับสินค้าด้วยตนเอง">รับสินค้าด้วยตนเอง</option>
          <option value="จัดส่งทางไปรษณีย์">จัดส่งทางไปรษณีย์</option>
        </select>
      </div>
      <div id="customerInfo" class="border rounded p-3 bg-white" style="display:none;">
        <h6 class="text-secondary mb-2">ข้อมูลผู้จอง / ผู้รับสินค้า</h6>
        <div class="row">
          <div class="col-md-6 mb-3"><label>ชื่อ-นามสกุล</label><input type="text" name="fullname" id="fullname" class="form-control"></div>
          <div class="col-md-6 mb-3"><label>เบอร์โทรศัพท์</label><input type="text" name="phone" id="phone" class="form-control"></div>
        </div>
        <div class="mb-3"><label>ที่อยู่จัดส่ง</label><textarea name="address" id="address" class="form-control" rows="2"></textarea></div>
        <div class="col-md-4 mb-3"><label>รหัสไปรษณีย์</label><input type="text" name="zipcode" id="zipcode" class="form-control"></div>
      </div>
      <div class="d-flex justify-content-between mt-3">
        <button type="button" class="btn btn-secondary" id="prevStep">⬅ ย้อนกลับ</button>
        <button type="submit" class="btn btn-success">ดำเนินการต่อ ➜</button>
      </div>
    </div>
  </form>
</div>
<script>
document.getElementById('nextStep').onclick=function(){
  const chk=document.querySelectorAll('input[name="product_id[]"]:checked');
  if(chk.length===0){alert('กรุณาเลือกรายการพระอย่างน้อย 1 รายการ');return;}
  document.getElementById('step1').classList.remove('active');
  document.getElementById('step2').classList.add('active');
}
document.getElementById('prevStep').onclick=function(){
  document.getElementById('step2').classList.remove('active');
  document.getElementById('step1').classList.add('active');
}
document.getElementById('receiveMethod').onchange=function(){
  document.getElementById('customerInfo').style.display=(this.value!='')?'block':'none';
}
document.getElementById('bookingForm').onsubmit=function(e){
  const method=document.getElementById('receiveMethod').value;
  const name=document.getElementById('fullname').value.trim();
  const phone=document.getElementById('phone').value.trim();
  const addr=document.getElementById('address').value.trim();
  if(method=='จัดส่งทางไปรษณีย์' && (!name||!phone||!addr)){
    alert('กรุณากรอกข้อมูลให้ครบสำหรับการจัดส่ง');
    e.preventDefault();
  }
}
</script>
</body>
</html>