<?php
include('../config/db.php');
session_start();
$selected = $_POST['product_id'] ?? [];
if(empty($selected)) { header("Location: index.php"); exit; }

$fullname = $_POST['fullname'] ?? '';
$phone = $_POST['phone'] ?? '';
$address = $_POST['address'] ?? '';
$zipcode = $_POST['zipcode'] ?? '';
$receive_method = $_POST['receive_method'] ?? '';

$total = 0;
$items = [];
foreach($selected as $pid){
  $q = intval($_POST['qty'][$pid] ?? 1);
  $r = $conn->query("SELECT * FROM products WHERE id=$pid")->fetch_assoc();
  $sum = $r['price']*$q;
  $total += $sum;
  $items[] = ['name'=>$r['name'],'qty'=>$q,'price'=>$r['price'],'sum'=>$sum];
}
?>
<!DOCTYPE html>
<html lang="th">
<head>
<meta charset="UTF-8">
<title>สรุปการสั่งจอง</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="../assets/css/style.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
  <div class="card shadow p-4">
    <h4>สรุปรายการจอง</h4>
    <table class="table table-bordered mt-3">
      <thead><tr><th>ชื่อพระ</th><th>จำนวน</th><th>ราคา/หน่วย</th><th>รวม</th></tr></thead>
      <tbody>
      <?php foreach($items as $it): ?>
      <tr>
        <td><?=$it['name']?></td>
        <td><?=$it['qty']?></td>
        <td><?=number_format($it['price'],2)?></td>
        <td><?=number_format($it['sum'],2)?></td>
      </tr>
      <?php endforeach; ?>
      <tr><th colspan="3" class="text-end">ยอดรวม</th><th><?=number_format($total,2)?></th></tr>
      </tbody>
    </table>
    <h5 class="mt-3">ยอดที่ต้องโอน: <b><?=number_format($total,2)?> บาท</b></h5>
    <p>กรุณาชำระเงินโดยสแกน QR Code ด้านล่าง แล้วอัปโหลดสลิปในขั้นตอนถัดไป</p>
    <div class="text-center"><img src="../assets/img/qrcode.png" alt="QR" width="200"></div>
    <form method="post" action="upload_slip.php" enctype="multipart/form-data" class="mt-4">
      <input type="hidden" name="fullname" value="<?=$fullname?>">
      <input type="hidden" name="phone" value="<?=$phone?>">
      <input type="hidden" name="address" value="<?=$address?>">
      <input type="hidden" name="zipcode" value="<?=$zipcode?>">
      <input type="hidden" name="receive_method" value="<?=$receive_method?>">
      <input type="hidden" name="total" value="<?=$total?>">
      <?php foreach($items as $i): ?>
        <input type="hidden" name="product_name[]" value="<?=$i['name']?>">
        <input type="hidden" name="qty[]" value="<?=$i['qty']?>">
        <input type="hidden" name="price[]" value="<?=$i['price']?>">
      <?php endforeach; ?>
      <div class="mb-3"><label>แนบสลิปชำระเงิน</label><input type="file" name="slip" class="form-control" required></div>
      <button class="btn btn-success w-100">ส่งหลักฐานการชำระเงิน</button>
    </form>
  </div>
</div>
</body>
</html>