<!DOCTYPE html>
<html lang="th">
<head>
  <meta charset="UTF-8">
  <title>CMTC Booking System</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
  <h2 class="text-center mb-4">ระบบจองพระวัดสันติสุข (CMTC Booking System)</h2>
  <div class="row justify-content-center">
    <div class="col-md-8">
      <div class="card shadow-lg p-4">
        <h4 class="text-center mb-3">รายการพระทั้งหมด</h4>
        <?php
        include('config/db.php');
        $res = $conn->query("SELECT * FROM products");
        echo '<div class="row">';
        while($r = $res->fetch_assoc()):
          $img1 = !empty($r['img1']) ? "uploads/products/{$r['img1']}" : '';
          $img2 = !empty($r['img2']) ? "uploads/products/{$r['img2']}" : '';
        ?>
          <div class="col-md-4 mb-4">
            <div class="card h-100">
              <?php if($img1 || $img2): ?>
              <div class="dual-img p-2 text-center">
                <?php if($img1): ?><div class="img-block"><img src="<?=$img1?>" class="img-fluid rounded"><span class="img-label">ด้านหน้า</span></div><?php endif; ?>
                <?php if($img2): ?><div class="img-block"><img src="<?=$img2?>" class="img-fluid rounded"><span class="img-label">ด้านหลัง</span></div><?php endif; ?>
              </div>
              <?php endif; ?>
              <div class="card-body text-center">
                <h5><?=$r['name']?></h5>
                <p>ราคา <?=number_format($r['price'],2)?> บาท</p>
                <p>คงเหลือ: <?=$r['stock'] > 0 ? $r['stock'] : '<span class="text-danger">หมด (Free Order)</span>'?></p>
              </div>
            </div>
          </div>
        <?php endwhile; echo '</div>'; ?>
        <div class="text-center mt-4">
          <a href="user/index.php" class="btn btn-primary">เริ่มต้นจองพระ</a>
          <a href="admin/index.php" class="btn btn-secondary">เข้าสู่ระบบผู้ดูแล</a>
        </div>
      </div>
    </div>
  </div>
</div>
</body>
</html>