<?php
session_start();
if(!isset($_SESSION['admin'])) { header('Location: index.php'); exit; }
include('../config/db.php');

// เพิ่มสินค้าใหม่
if(isset($_POST['add'])) {
  $name = $_POST['name'];
  $price = $_POST['price'];
  $stock = $_POST['stock'];
  $img1 = ""; $img2 = "";

  if(isset($_FILES['img1']['name']) && $_FILES['img1']['name'] != '') {
    $img1 = time() . "_1_" . basename($_FILES['img1']['name']);
    move_uploaded_file($_FILES['img1']['tmp_name'], "../uploads/products/" . $img1);
  }
  if(isset($_FILES['img2']['name']) && $_FILES['img2']['name'] != '') {
    $img2 = time() . "_2_" . basename($_FILES['img2']['name']);
    move_uploaded_file($_FILES['img2']['tmp_name'], "../uploads/products/" . $img2);
  }

  $conn->query("INSERT INTO products (name, price, stock, img1, img2) VALUES ('$name', '$price', '$stock', '$img1', '$img2')");
}

// ลบสินค้า
if(isset($_GET['del'])) {
  $id = $_GET['del'];
  $conn->query("DELETE FROM products WHERE id=$id");
  header("Location: products.php");
  exit;
}

// ดึงข้อมูลสินค้า
$res = $conn->query("SELECT * FROM products ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="th">
<head>
<meta charset="UTF-8">
<title>จัดการสินค้า</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="../assets/css/style.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include("menu.php"); ?>
<div class="container py-4">
  <h3 class="mb-4">📦 จัดการสินค้า</h3>
  <div class="card p-4 mb-4 shadow-sm">
    <form method="post" enctype="multipart/form-data">
      <div class="row g-3 align-items-end">
        <div class="col-md-3">
          <label>ชื่อพระ</label>
          <input type="text" name="name" class="form-control" required>
        </div>
        <div class="col-md-2">
          <label>ราคา</label>
          <input type="number" name="price" step="0.01" class="form-control" required>
        </div>
        <div class="col-md-2">
          <label>คงเหลือ</label>
          <input type="number" name="stock" class="form-control" required>
        </div>
        <div class="col-md-2">
          <label>ภาพด้านหน้า</label>
          <input type="file" name="img1" class="form-control">
        </div>
        <div class="col-md-2">
          <label>ภาพด้านหลัง</label>
          <input type="file" name="img2" class="form-control">
        </div>
        <div class="col-md-1">
          <button type="submit" name="add" class="btn btn-primary w-100">เพิ่ม</button>
        </div>
      </div>
    </form>
  </div>

  <table class="table table-bordered bg-white shadow-sm align-middle">
    <thead class="table-dark">
      <tr class="text-center">
        <th>รหัส</th>
        <th>ชื่อพระ</th>
        <th>ราคา</th>
        <th>คงเหลือ</th>
        <th>รูปภาพ</th>
        <th>ลบ</th>
      </tr>
    </thead>
    <?php while($r = $res->fetch_assoc()): ?>
    <tr>
      <td class="text-center"><?= $r['id'] ?></td>
      <td><?= $r['name'] ?></td>
      <td class="text-center"><?= number_format($r['price'],2) ?></td>
      <td class="text-center"><?= $r['stock'] ?></td>
      <td class="text-center">
        <?php if($r['img1']): ?><img src="../uploads/products/<?=$r['img1']?>" width="60"><?php endif; ?>
        <?php if($r['img2']): ?><img src="../uploads/products/<?=$r['img2']?>" width="60"><?php endif; ?>
      </td>
      <td class="text-center"><a href="?del=<?=$r['id']?>" class="btn btn-danger btn-sm" onclick="return confirm('ยืนยันการลบ?')">ลบ</a></td>
    </tr>
    <?php endwhile; ?>
  </table>
</div>
</body>
</html>