<?php
session_start();
if(!isset($_SESSION['admin'])) { header('Location: index.php'); exit; }
include('../config/db.php');

$admin_password = "1234"; // ใช้ค่ายืนยันเริ่มต้น

// ✅ ยืนยันคำสั่งซื้อ (ตัดสต็อก)
if(isset($_GET['confirm'])) {
    $id = intval($_GET['confirm']);
    $items = $conn->query("SELECT product_id, qty FROM order_items WHERE order_id=$id");
    while($it = $items->fetch_assoc()) {
        $conn->query("UPDATE products SET stock = stock - {$it['qty']} WHERE id = {$it['product_id']} AND stock >= {$it['qty']}");
    }
    $conn->query("UPDATE orders SET status='ชำระเงินแล้ว' WHERE id=$id");
    header("Location: orders.php?done=1");
    exit;
}

// ✅ ยกเลิก (คืนสินค้า + รหัสผ่าน)
if(isset($_POST['cancel_id'])) {
    $oid = intval($_POST['cancel_id']);
    $pw = trim($_POST['password']);
    if($pw === $admin_password) {
        $items = $conn->query("SELECT product_id, qty FROM order_items WHERE order_id=$oid");
        while($it = $items->fetch_assoc()) {
            $conn->query("UPDATE products SET stock = stock + {$it['qty']} WHERE id = {$it['product_id']}");
        }
        $conn->query("UPDATE orders SET status='ยกเลิกแล้ว' WHERE id=$oid");
        $msg = "✅ ยกเลิกคำสั่งซื้อเรียบร้อย";
    } else {
        $msg = "❌ รหัสผ่านไม่ถูกต้อง!";
    }
}

// ✅ เปลี่ยนสถานะทั่วไป
if(isset($_GET['id']) && isset($_GET['status'])) {
    $id = intval($_GET['id']);
    $st = $_GET['status'];
    $conn->query("UPDATE orders SET status='$st' WHERE id=$id");
    header("Location: orders.php?updated=1");
    exit;
}

// ✅ ดึงรายการคำสั่งซื้อทั้งหมด
$res = $conn->query("
SELECT o.*, GROUP_CONCAT(CONCAT(p.name,' x',i.qty) SEPARATOR ', ') AS items
FROM orders o
JOIN order_items i ON o.id=i.order_id
JOIN products p ON i.product_id=p.id
GROUP BY o.id
ORDER BY o.id DESC
");
?>
<!DOCTYPE html>
<html lang="th">
<head>
<meta charset="UTF-8">
<title>จัดการคำสั่งจอง</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="../assets/css/style.css" rel="stylesheet">
<style>
.password-box { display:none; margin-top:5px; }
</style>
</head>
<body class="bg-light">
<?php include("menu.php"); ?>
<div class="container py-4">
  <h3 class="mb-3">📜 จัดการคำสั่งจอง</h3>
  <?php if(isset($msg)): ?><div class="alert alert-info"><?= $msg ?></div><?php endif; ?>
  <table class="table table-bordered bg-white shadow-sm align-middle">
    <thead class="table-dark">
      <tr>
        <th>เลขที่ใบจอง</th>
        <th>ชื่อผู้จอง</th>
        <th>รายการพระ</th>
        <th>ยอดรวม</th>
        <th>สถานะ</th>
        <th>สลิป</th>
        <th>จัดการ</th>
        <th>ใบเสร็จ</th>
      </tr>
    </thead>
    <?php while($r=$res->fetch_assoc()): ?>
    <tr>
      <td><?=$r['booking_no']?></td>
      <td><?=$r['fullname']?></td>
      <td><?=$r['items']?></td>
      <td><?=number_format($r['total'],2)?></td>
      <td><b><?=$r['status']?></b></td>
      <td>
        <?php if($r['slip']): ?>
          <a href="../uploads/slip/<?=$r['slip']?>" target="_blank">ดู</a>
        <?php else: ?> - <?php endif; ?>
      </td>
      <td>
        <?php if($r['status']=='รอตรวจสอบ' || $r['status']=='ยืนยันแล้ว'): ?>
          <a href="?confirm=<?=$r['id']?>" class="btn btn-success btn-sm">✔ ยืนยัน</a>
        <?php elseif($r['status']=='ชำระเงินแล้ว'): ?>
          <div class="dropdown d-inline mb-1">
            <button class="btn btn-secondary btn-sm dropdown-toggle" data-bs-toggle="dropdown">เปลี่ยนสถานะ</button>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="?id=<?=$r['id']?>&status=รับ order แล้ว">รับ order แล้ว</a></li>
              <li><a class="dropdown-item" href="?id=<?=$r['id']?>&status=มารับเหรียญได้ที่วิทยาลัยฯ">มารับเหรียญได้ที่วิทยาลัยฯ</a></li>
              <li><a class="dropdown-item" href="?id=<?=$r['id']?>&status=กำลังจัดส่ง">กำลังจัดส่ง</a></li>
              <li><a class="dropdown-item" href="?id=<?=$r['id']?>&status=รับเหรียญเรียบร้อยแล้ว">รับเหรียญเรียบร้อยแล้ว</a></li>
              <li><a class="dropdown-item" href="?id=<?=$r['id']?>&status=จัดส่งเรียบร้อยแล้ว">จัดส่งเรียบร้อยแล้ว</a></li>
            </ul>
          </div>
          <button class="btn btn-danger btn-sm" onclick="toggleCancel(<?=$r['id']?>)">❌ ยกเลิก</button>
          <div id="cancelBox<?=$r['id']?>" class="password-box">
            <form method="post">
              <input type="hidden" name="cancel_id" value="<?=$r['id']?>">
              <input type="password" name="password" class="form-control form-control-sm mt-1" placeholder="รหัสผ่าน">
              <button type="submit" class="btn btn-warning btn-sm mt-1">ยืนยัน</button>
            </form>
          </div>
        <?php elseif($r['status']=='ยกเลิกแล้ว'): ?>
          <span class="text-muted">คำสั่งนี้ถูกยกเลิก</span>
        <?php else: ?>
          <span class="text-secondary">-</span>
        <?php endif; ?>
      </td>
      <td><a href="print_invoice.php?id=<?=$r['id']?>" target="_blank" class="btn btn-outline-primary btn-sm">🖨 พิมพ์</a></td>
    </tr>
    <?php endwhile; ?>
  </table>
</div>
<script>
function toggleCancel(id){
  const box=document.getElementById('cancelBox'+id);
  box.style.display = (box.style.display=='block'?'none':'block');
}
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>